/*
 * This declarations of the PIC16F887 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:30:16 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F887_H__
#define __PIC16F887_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PORTD_ADDR              0x0008
#define PORTE_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define SSPBUF_ADDR             0x0013
#define SSPCON_ADDR             0x0014
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define RCSTA_ADDR              0x0018
#define TXREG_ADDR              0x0019
#define RCREG_ADDR              0x001A
#define CCPR2_ADDR              0x001B
#define CCPR2L_ADDR             0x001B
#define CCPR2H_ADDR             0x001C
#define CCP2CON_ADDR            0x001D
#define ADRESH_ADDR             0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define TRISD_ADDR              0x0088
#define TRISE_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define PCON_ADDR               0x008E
#define OSCCON_ADDR             0x008F
#define OSCTUNE_ADDR            0x0090
#define SSPCON2_ADDR            0x0091
#define PR2_ADDR                0x0092
#define MSK_ADDR                0x0093
#define SSPADD_ADDR             0x0093
#define SSPMSK_ADDR             0x0093
#define SSPSTAT_ADDR            0x0094
#define WPUB_ADDR               0x0095
#define IOCB_ADDR               0x0096
#define VRCON_ADDR              0x0097
#define TXSTA_ADDR              0x0098
#define SPBRG_ADDR              0x0099
#define SPBRGH_ADDR             0x009A
#define PWM1CON_ADDR            0x009B
#define ECCPAS_ADDR             0x009C
#define PSTRCON_ADDR            0x009D
#define ADRESL_ADDR             0x009E
#define ADCON1_ADDR             0x009F
#define WDTCON_ADDR             0x0105
#define CM1CON0_ADDR            0x0107
#define CM2CON0_ADDR            0x0108
#define CM2CON1_ADDR            0x0109
#define EEDAT_ADDR              0x010C
#define EEDATA_ADDR             0x010C
#define EEADR_ADDR              0x010D
#define EEDATH_ADDR             0x010E
#define EEADRH_ADDR             0x010F
#define SRCON_ADDR              0x0185
#define BAUDCTL_ADDR            0x0187
#define ANSEL_ADDR              0x0188
#define ANSELH_ADDR             0x0189
#define EECON1_ADDR             0x018C
#define EECON2_ADDR             0x018D

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0008) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x0008) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0009) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 4;
    unsigned                    : 4;
    };
  } __PORTEbits_t;

extern __at(0x0009) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned T0IF               : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _TMR0IF                 0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _TMR0IE                 0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned ULPWUIF              : 1;
  unsigned BCLIF                : 1;
  unsigned EEIF                 : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _ULPWUIF                0x04
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1GE             : 1;
    unsigned T1GINV             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GIV              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1GE                 0x40
#define _T1GINV                 0x80
#define _T1GIV                  0x80

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0013) __sfr SSPBUF;

//==============================================================================
//        SSPCON Bits

extern __at(0x0014) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0014) volatile __SSPCONbits_t SSPCONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0018) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC9                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0018) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _SPEN                   0x80

//==============================================================================

extern __at(0x0019) __sfr TXREG;
extern __at(0x001A) __sfr RCREG;
extern __at(0x001B) __sfr CCPR2;
extern __at(0x001B) __sfr CCPR2L;
extern __at(0x001C) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x001D) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x001D) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20

//==============================================================================

extern __at(0x001E) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0088) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0088) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0089) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISE              : 4;
    unsigned                    : 4;
    };
  } __TRISEbits_t;

extern __at(0x0089) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned ULPWUIE              : 1;
  unsigned BCLIE                : 1;
  unsigned EEIE                 : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _ULPWUIE                0x04
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned ULPWUE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BO             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BO                 0x01
#define _NOT_POR                0x02
#define _SBOREN                 0x10
#define _ULPWUE                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x008F) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS                : 1;
    unsigned LTS                : 1;
    unsigned HTS                : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x008F) volatile __OSCCONbits_t OSCCONbits;

#define _SCS                    0x01
#define _LTS                    0x02
#define _HTS                    0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0090) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0090) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0091) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0091) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================

extern __at(0x0092) __sfr PR2;

//==============================================================================
//        MSK Bits

extern __at(0x0093) __sfr MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __MSKbits_t;

extern __at(0x0093) volatile __MSKbits_t MSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================

extern __at(0x0093) __sfr SSPADD;

//==============================================================================
//        SSPMSK Bits

extern __at(0x0093) __sfr SSPMSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPMSKbits_t;

extern __at(0x0093) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_MSK0            0x01
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0094) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DATA           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0094) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _I2C_READ               0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _R_W                    0x04
#define _READ_WRITE             0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _I2C_DATA               0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _D_A                    0x20
#define _DATA_ADDRESS           0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0095) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0095) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0096) __sfr IOCB;

typedef struct
  {
  unsigned IOCB0                : 1;
  unsigned IOCB1                : 1;
  unsigned IOCB2                : 1;
  unsigned IOCB3                : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0096) volatile __IOCBbits_t IOCBbits;

#define _IOCB0                  0x01
#define _IOCB1                  0x02
#define _IOCB2                  0x04
#define _IOCB3                  0x08
#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        VRCON Bits

extern __at(0x0097) __sfr VRCON;

typedef union
  {
  struct
    {
    unsigned VR0                : 1;
    unsigned VR1                : 1;
    unsigned VR2                : 1;
    unsigned VR3                : 1;
    unsigned VRSS               : 1;
    unsigned VRR                : 1;
    unsigned VROE               : 1;
    unsigned VREN               : 1;
    };

  struct
    {
    unsigned VR                 : 4;
    unsigned                    : 4;
    };
  } __VRCONbits_t;

extern __at(0x0097) volatile __VRCONbits_t VRCONbits;

#define _VR0                    0x01
#define _VR1                    0x02
#define _VR2                    0x04
#define _VR3                    0x08
#define _VRSS                   0x10
#define _VRR                    0x20
#define _VROE                   0x40
#define _VREN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0098) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX8_9              : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0098) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _NOT_TX8                0x40
#define _TX8_9                  0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        SPBRG Bits

extern __at(0x0099) __sfr SPBRG;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRGbits_t;

extern __at(0x0099) volatile __SPBRGbits_t SPBRGbits;

#define _BRG0                   0x01
#define _BRG1                   0x02
#define _BRG2                   0x04
#define _BRG3                   0x08
#define _BRG4                   0x10
#define _BRG5                   0x20
#define _BRG6                   0x40
#define _BRG7                   0x80

//==============================================================================


//==============================================================================
//        SPBRGH Bits

extern __at(0x009A) __sfr SPBRGH;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SPBRGHbits_t;

extern __at(0x009A) volatile __SPBRGHbits_t SPBRGHbits;

#define _BRG8                   0x01
#define _BRG9                   0x02
#define _BRG10                  0x04
#define _BRG11                  0x08
#define _BRG12                  0x10
#define _BRG13                  0x20
#define _BRG14                  0x40
#define _BRG15                  0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x009B) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x009B) volatile __PWM1CONbits_t PWM1CONbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        ECCPAS Bits

extern __at(0x009C) __sfr ECCPAS;

typedef union
  {
  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCPASbits_t;

extern __at(0x009C) volatile __ECCPASbits_t ECCPASbits;

#define _PSSBD0                 0x01
#define _PSSBD1                 0x02
#define _PSSAC0                 0x04
#define _PSSAC1                 0x08
#define _ECCPAS0                0x10
#define _ECCPAS1                0x20
#define _ECCPAS2                0x40
#define _ECCPASE                0x80

//==============================================================================


//==============================================================================
//        PSTRCON Bits

extern __at(0x009D) __sfr PSTRCON;

typedef struct
  {
  unsigned STRA                 : 1;
  unsigned STRB                 : 1;
  unsigned STRC                 : 1;
  unsigned STRD                 : 1;
  unsigned STRSYNC              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTRCONbits_t;

extern __at(0x009D) volatile __PSTRCONbits_t PSTRCONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10

//==============================================================================

extern __at(0x009E) __sfr ADRESL;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _VCFG0                  0x10
#define _VCFG1                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0105) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 4;
    unsigned                    : 3;
    };
  } __WDTCONbits_t;

extern __at(0x0105) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0107) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned                    : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0107) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0108) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned                    : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x0108) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0109) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned T1GSS                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x0109) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _T1GSS                  0x02
#define _C2RSEL                 0x10
#define _C1RSEL                 0x20
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================

extern __at(0x010C) __sfr EEDAT;
extern __at(0x010C) __sfr EEDATA;
extern __at(0x010D) __sfr EEADR;
extern __at(0x010E) __sfr EEDATH;
extern __at(0x010F) __sfr EEADRH;

//==============================================================================
//        SRCON Bits

extern __at(0x0185) __sfr SRCON;

typedef union
  {
  struct
    {
    unsigned FVREN              : 1;
    unsigned                    : 1;
    unsigned PULSR              : 1;
    unsigned PULSS              : 1;
    unsigned C2REN              : 1;
    unsigned C1SEN              : 1;
    unsigned SR0                : 1;
    unsigned SR1                : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SR                 : 2;
    };
  } __SRCONbits_t;

extern __at(0x0185) volatile __SRCONbits_t SRCONbits;

#define _FVREN                  0x01
#define _PULSR                  0x04
#define _PULSS                  0x08
#define _C2REN                  0x10
#define _C1SEN                  0x20
#define _SR0                    0x40
#define _SR1                    0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0187) __sfr BAUDCTL;

#define BAUDCON BAUDCTL

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x0187) volatile __BAUDCTLbits_t BAUDCTLbits;

#define BAUDCONbits BAUDCTLbits

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x0188) __sfr ANSEL;

typedef struct
  {
  unsigned ANS0                 : 1;
  unsigned ANS1                 : 1;
  unsigned ANS2                 : 1;
  unsigned ANS3                 : 1;
  unsigned ANS4                 : 1;
  unsigned ANS5                 : 1;
  unsigned ANS6                 : 1;
  unsigned ANS7                 : 1;
  } __ANSELbits_t;

extern __at(0x0188) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS2                   0x04
#define _ANS3                   0x08
#define _ANS4                   0x10
#define _ANS5                   0x20
#define _ANS6                   0x40
#define _ANS7                   0x80

//==============================================================================


//==============================================================================
//        ANSELH Bits

extern __at(0x0189) __sfr ANSELH;

typedef struct
  {
  unsigned ANS8                 : 1;
  unsigned ANS9                 : 1;
  unsigned ANS10                : 1;
  unsigned ANS11                : 1;
  unsigned ANS12                : 1;
  unsigned ANS13                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELHbits_t;

extern __at(0x0189) volatile __ANSELHbits_t ANSELHbits;

#define _ANS8                   0x01
#define _ANS9                   0x02
#define _ANS10                  0x04
#define _ANS11                  0x08
#define _ANS12                  0x10
#define _ANS13                  0x20

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x018C) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x018C) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x018D) __sfr EECON2;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x2007
#define _CONFIG2                0x2008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _LP_OSC                 0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _FOSC_XT                0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _XT_OSC                 0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _FOSC_HS                0x3FFA  // HS oscillator: High-speed crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _HS_OSC                 0x3FFA  // HS oscillator: High-speed crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN.
#define _FOSC_EC                0x3FFB  // EC: I/O function on RA6/OSC2/CLKOUT pin, CLKIN on RA7/OSC1/CLKIN.
#define _EC_OSC                 0x3FFB  // EC: I/O function on RA6/OSC2/CLKOUT pin, CLKIN on RA7/OSC1/CLKIN.
#define _FOSC_INTRC_NOCLKOUT    0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _INTRC_OSC_NOCLKOUT     0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _INTOSCIO               0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _FOSC_INTRC_CLKOUT      0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _INTRC_OSC_CLKOUT       0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _INTOSC                 0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, I/O function on RA7/OSC1/CLKIN.
#define _FOSC_EXTRC_NOCLKOUT    0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRC_OSC_NOCLKOUT     0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRCIO                0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _FOSC_EXTRC_CLKOUT      0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRC_OSC_CLKOUT       0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _EXTRC                  0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT pin, RC on RA7/OSC1/CLKIN.
#define _WDTE_OFF               0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // RE3/MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // RE3/MCLR pin function is MCLR.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _CPD_ON                 0x3F7F  // Data memory code protection is enabled.
#define _CPD_OFF                0x3FFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0x3CFF  // BOR disabled.
#define _BOR_OFF                0x3CFF  // BOR disabled.
#define _BOREN_SBODEN           0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOR_SBODEN             0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOREN_NSLEEP           0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOR_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BOR_ON                 0x3FFF  // BOR enabled.
#define _IESO_OFF               0x3BFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0x37FF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.
#define _LVP_OFF                0x2FFF  // RB3 pin has digital I/O, HV on MCLR must be used for programming.
#define _LVP_ON                 0x3FFF  // RB3/PGM pin has PGM function, low voltage programming enabled.
#define _DEBUG_ON               0x1FFF  // In_Circuit Debugger enabled, RB6/ICSPCLK and RB7/ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, RB6/ICSPCLK and RB7/ICSPDAT are general purpose I/O pins.

//----------------------------- CONFIG2 Options -------------------------------

#define _BOR4V_BOR21V           0x3EFF  // Brown-out Reset set to 2.1V.
#define _BOR21V                 0x3EFF  // Brown-out Reset set to 2.1V.
#define _BOR4V_BOR40V           0x3FFF  // Brown-out Reset set to 4.0V.
#define _BOR40V                 0x3FFF  // Brown-out Reset set to 4.0V.
#define _WRT_HALF               0x39FF  // 0000h to 0FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_1FOURTH            0x3BFF  // 0000h to 07FFh write protected, 0800h to 1FFFh may be modified by EECON control.
#define _WRT_256                0x3DFF  // 0000h to 00FFh write protected, 0100h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define ADCS0                   ADCON0bits.ADCS0                // bit 6
#define ADCS1                   ADCON0bits.ADCS1                // bit 7

#define VCFG0                   ADCON1bits.VCFG0                // bit 4
#define VCFG1                   ADCON1bits.VCFG1                // bit 5
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANS0                    ANSELbits.ANS0                  // bit 0
#define ANS1                    ANSELbits.ANS1                  // bit 1
#define ANS2                    ANSELbits.ANS2                  // bit 2
#define ANS3                    ANSELbits.ANS3                  // bit 3
#define ANS4                    ANSELbits.ANS4                  // bit 4
#define ANS5                    ANSELbits.ANS5                  // bit 5
#define ANS6                    ANSELbits.ANS6                  // bit 6
#define ANS7                    ANSELbits.ANS7                  // bit 7

#define ANS8                    ANSELHbits.ANS8                 // bit 0
#define ANS9                    ANSELHbits.ANS9                 // bit 1
#define ANS10                   ANSELHbits.ANS10                // bit 2
#define ANS11                   ANSELHbits.ANS11                // bit 3
#define ANS12                   ANSELHbits.ANS12                // bit 4
#define ANS13                   ANSELHbits.ANS13                // bit 5

#define ABDEN                   BAUDCTLbits.ABDEN               // bit 0
#define WUE                     BAUDCTLbits.WUE                 // bit 1
#define BRG16                   BAUDCTLbits.BRG16               // bit 3
#define SCKP                    BAUDCTLbits.SCKP                // bit 4
#define RCIDL                   BAUDCTLbits.RCIDL               // bit 6
#define ABDOVF                  BAUDCTLbits.ABDOVF              // bit 7

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4, shadows bit in CCP1CONbits
#define CCP1Y                   CCP1CONbits.CCP1Y               // bit 4, shadows bit in CCP1CONbits
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5, shadows bit in CCP1CONbits
#define CCP1X                   CCP1CONbits.CCP1X               // bit 5, shadows bit in CCP1CONbits
#define P1M0                    CCP1CONbits.P1M0                // bit 6
#define P1M1                    CCP1CONbits.P1M1                // bit 7

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4, shadows bit in CCP2CONbits
#define CCP2Y                   CCP2CONbits.CCP2Y               // bit 4, shadows bit in CCP2CONbits
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5, shadows bit in CCP2CONbits
#define CCP2X                   CCP2CONbits.CCP2X               // bit 5, shadows bit in CCP2CONbits

#define C1CH0                   CM1CON0bits.C1CH0               // bit 0
#define C1CH1                   CM1CON0bits.C1CH1               // bit 1
#define C1R                     CM1CON0bits.C1R                 // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C2CH0                   CM2CON0bits.C2CH0               // bit 0
#define C2CH1                   CM2CON0bits.C2CH1               // bit 1
#define C2R                     CM2CON0bits.C2R                 // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2SYNC                  CM2CON1bits.C2SYNC              // bit 0
#define T1GSS                   CM2CON1bits.T1GSS               // bit 1
#define C2RSEL                  CM2CON1bits.C2RSEL              // bit 4
#define C1RSEL                  CM2CON1bits.C1RSEL              // bit 5
#define MC2OUT                  CM2CON1bits.MC2OUT              // bit 6
#define MC1OUT                  CM2CON1bits.MC1OUT              // bit 7

#define PSSBD0                  ECCPASbits.PSSBD0               // bit 0
#define PSSBD1                  ECCPASbits.PSSBD1               // bit 1
#define PSSAC0                  ECCPASbits.PSSAC0               // bit 2
#define PSSAC1                  ECCPASbits.PSSAC1               // bit 3
#define ECCPAS0                 ECCPASbits.ECCPAS0              // bit 4
#define ECCPAS1                 ECCPASbits.ECCPAS1              // bit 5
#define ECCPAS2                 ECCPASbits.ECCPAS2              // bit 6
#define ECCPASE                 ECCPASbits.ECCPASE              // bit 7

#define RD                      EECON1bits.RD                   // bit 0
#define WR                      EECON1bits.WR                   // bit 1
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCB0                   IOCBbits.IOCB0                  // bit 0
#define IOCB1                   IOCBbits.IOCB1                  // bit 1
#define IOCB2                   IOCBbits.IOCB2                  // bit 2
#define IOCB3                   IOCBbits.IOCB3                  // bit 3
#define IOCB4                   IOCBbits.IOCB4                  // bit 4
#define IOCB5                   IOCBbits.IOCB5                  // bit 5
#define IOCB6                   IOCBbits.IOCB6                  // bit 6
#define IOCB7                   IOCBbits.IOCB7                  // bit 7

#define MSK0                    MSKbits.MSK0                    // bit 0
#define MSK1                    MSKbits.MSK1                    // bit 1
#define MSK2                    MSKbits.MSK2                    // bit 2
#define MSK3                    MSKbits.MSK3                    // bit 3
#define MSK4                    MSKbits.MSK4                    // bit 4
#define MSK5                    MSKbits.MSK5                    // bit 5
#define MSK6                    MSKbits.MSK6                    // bit 6
#define MSK7                    MSKbits.MSK7                    // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define SCS                     OSCCONbits.SCS                  // bit 0
#define LTS                     OSCCONbits.LTS                  // bit 1
#define HTS                     OSCCONbits.HTS                  // bit 2
#define OSTS                    OSCCONbits.OSTS                 // bit 3
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5
#define IRCF2                   OSCCONbits.IRCF2                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BO                  PCONbits.NOT_BO                 // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define SBOREN                  PCONbits.SBOREN                 // bit 4
#define ULPWUE                  PCONbits.ULPWUE                 // bit 5

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSPIE                   PIE1bits.SSPIE                  // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define ULPWUIE                 PIE2bits.ULPWUIE                // bit 2
#define BCLIE                   PIE2bits.BCLIE                  // bit 3
#define EEIE                    PIE2bits.EEIE                   // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSPIF                   PIR1bits.SSPIF                  // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define ULPWUIF                 PIR2bits.ULPWUIF                // bit 2
#define BCLIF                   PIR2bits.BCLIF                  // bit 3
#define EEIF                    PIR2bits.EEIF                   // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2
#define RE3                     PORTEbits.RE3                   // bit 3

#define STRA                    PSTRCONbits.STRA                // bit 0
#define STRB                    PSTRCONbits.STRB                // bit 1
#define STRC                    PSTRCONbits.STRC                // bit 2
#define STRD                    PSTRCONbits.STRD                // bit 3
#define STRSYNC                 PSTRCONbits.STRSYNC             // bit 4

#define PDC0                    PWM1CONbits.PDC0                // bit 0
#define PDC1                    PWM1CONbits.PDC1                // bit 1
#define PDC2                    PWM1CONbits.PDC2                // bit 2
#define PDC3                    PWM1CONbits.PDC3                // bit 3
#define PDC4                    PWM1CONbits.PDC4                // bit 4
#define PDC5                    PWM1CONbits.PDC5                // bit 5
#define PDC6                    PWM1CONbits.PDC6                // bit 6
#define PRSEN                   PWM1CONbits.PRSEN               // bit 7

#define RX9D                    RCSTAbits.RX9D                  // bit 0, shadows bit in RCSTAbits
#define RCD8                    RCSTAbits.RCD8                  // bit 0, shadows bit in RCSTAbits
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6, shadows bit in RCSTAbits
#define RC9                     RCSTAbits.RC9                   // bit 6, shadows bit in RCSTAbits
#define NOT_RC8                 RCSTAbits.NOT_RC8               // bit 6, shadows bit in RCSTAbits
#define RC8_9                   RCSTAbits.RC8_9                 // bit 6, shadows bit in RCSTAbits
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define BRG0                    SPBRGbits.BRG0                  // bit 0
#define BRG1                    SPBRGbits.BRG1                  // bit 1
#define BRG2                    SPBRGbits.BRG2                  // bit 2
#define BRG3                    SPBRGbits.BRG3                  // bit 3
#define BRG4                    SPBRGbits.BRG4                  // bit 4
#define BRG5                    SPBRGbits.BRG5                  // bit 5
#define BRG6                    SPBRGbits.BRG6                  // bit 6
#define BRG7                    SPBRGbits.BRG7                  // bit 7

#define BRG8                    SPBRGHbits.BRG8                 // bit 0
#define BRG9                    SPBRGHbits.BRG9                 // bit 1
#define BRG10                   SPBRGHbits.BRG10                // bit 2
#define BRG11                   SPBRGHbits.BRG11                // bit 3
#define BRG12                   SPBRGHbits.BRG12                // bit 4
#define BRG13                   SPBRGHbits.BRG13                // bit 5
#define BRG14                   SPBRGHbits.BRG14                // bit 6
#define BRG15                   SPBRGHbits.BRG15                // bit 7

#define FVREN                   SRCONbits.FVREN                 // bit 0
#define PULSR                   SRCONbits.PULSR                 // bit 2
#define PULSS                   SRCONbits.PULSS                 // bit 3
#define C2REN                   SRCONbits.C2REN                 // bit 4
#define C1SEN                   SRCONbits.C1SEN                 // bit 5
#define SR0                     SRCONbits.SR0                   // bit 6
#define SR1                     SRCONbits.SR1                   // bit 7

#define SSPM0                   SSPCONbits.SSPM0                // bit 0
#define SSPM1                   SSPCONbits.SSPM1                // bit 1
#define SSPM2                   SSPCONbits.SSPM2                // bit 2
#define SSPM3                   SSPCONbits.SSPM3                // bit 3
#define CKP                     SSPCONbits.CKP                  // bit 4
#define SSPEN                   SSPCONbits.SSPEN                // bit 5
#define SSPOV                   SSPCONbits.SSPOV                // bit 6
#define WCOL                    SSPCONbits.WCOL                 // bit 7

#define SEN                     SSPCON2bits.SEN                 // bit 0
#define RSEN                    SSPCON2bits.RSEN                // bit 1
#define PEN                     SSPCON2bits.PEN                 // bit 2
#define RCEN                    SSPCON2bits.RCEN                // bit 3
#define ACKEN                   SSPCON2bits.ACKEN               // bit 4
#define ACKDT                   SSPCON2bits.ACKDT               // bit 5
#define ACKSTAT                 SSPCON2bits.ACKSTAT             // bit 6
#define GCEN                    SSPCON2bits.GCEN                // bit 7

#define BF                      SSPSTATbits.BF                  // bit 0
#define UA                      SSPSTATbits.UA                  // bit 1
#define R_NOT_W                 SSPSTATbits.R_NOT_W             // bit 2, shadows bit in SSPSTATbits
#define R                       SSPSTATbits.R                   // bit 2, shadows bit in SSPSTATbits
#define I2C_READ                SSPSTATbits.I2C_READ            // bit 2, shadows bit in SSPSTATbits
#define NOT_W                   SSPSTATbits.NOT_W               // bit 2, shadows bit in SSPSTATbits
#define NOT_WRITE               SSPSTATbits.NOT_WRITE           // bit 2, shadows bit in SSPSTATbits
#define R_W                     SSPSTATbits.R_W                 // bit 2, shadows bit in SSPSTATbits
#define READ_WRITE              SSPSTATbits.READ_WRITE          // bit 2, shadows bit in SSPSTATbits
#define S                       SSPSTATbits.S                   // bit 3, shadows bit in SSPSTATbits
#define I2C_START               SSPSTATbits.I2C_START           // bit 3, shadows bit in SSPSTATbits
#define P                       SSPSTATbits.P                   // bit 4, shadows bit in SSPSTATbits
#define I2C_STOP                SSPSTATbits.I2C_STOP            // bit 4, shadows bit in SSPSTATbits
#define D_NOT_A                 SSPSTATbits.D_NOT_A             // bit 5, shadows bit in SSPSTATbits
#define D                       SSPSTATbits.D                   // bit 5, shadows bit in SSPSTATbits
#define I2C_DATA                SSPSTATbits.I2C_DATA            // bit 5, shadows bit in SSPSTATbits
#define NOT_A                   SSPSTATbits.NOT_A               // bit 5, shadows bit in SSPSTATbits
#define NOT_ADDRESS             SSPSTATbits.NOT_ADDRESS         // bit 5, shadows bit in SSPSTATbits
#define D_A                     SSPSTATbits.D_A                 // bit 5, shadows bit in SSPSTATbits
#define DATA_ADDRESS            SSPSTATbits.DATA_ADDRESS        // bit 5, shadows bit in SSPSTATbits
#define CKE                     SSPSTATbits.CKE                 // bit 6
#define SMP                     SSPSTATbits.SMP                 // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1INSYNC                T1CONbits.T1INSYNC              // bit 2, shadows bit in T1CONbits
#define T1SYNC                  T1CONbits.T1SYNC                // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1GE                  T1CONbits.TMR1GE                // bit 6
#define T1GINV                  T1CONbits.T1GINV                // bit 7, shadows bit in T1CONbits
#define T1GIV                   T1CONbits.T1GIV                 // bit 7, shadows bit in T1CONbits

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TXSTAbits.TX9D                  // bit 0, shadows bit in TXSTAbits
#define TXD8                    TXSTAbits.TXD8                  // bit 0, shadows bit in TXSTAbits
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SENDB                   TXSTAbits.SENDB                 // bit 3
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6, shadows bit in TXSTAbits
#define NOT_TX8                 TXSTAbits.NOT_TX8               // bit 6, shadows bit in TXSTAbits
#define TX8_9                   TXSTAbits.TX8_9                 // bit 6, shadows bit in TXSTAbits
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define VR0                     VRCONbits.VR0                   // bit 0
#define VR1                     VRCONbits.VR1                   // bit 1
#define VR2                     VRCONbits.VR2                   // bit 2
#define VR3                     VRCONbits.VR3                   // bit 3
#define VRSS                    VRCONbits.VRSS                  // bit 4
#define VRR                     VRCONbits.VRR                   // bit 5
#define VROE                    VRCONbits.VROE                  // bit 6
#define VREN                    VRCONbits.VREN                  // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F887_H__
